package org.mulesoft.apb.project.client.scala.model.documentation

import amf.core.client.scala.model.StrField
import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.{Instance, InstanceModel, JsonLDObjectWrapper, UnwrappedFields}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.MetadataModel.entityModel
import org.mulesoft.apb.project.client.scala.model.documentation.DocumentationModel.{Name, Path}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Core

case class Documentation(override private[apb] val wrapped: JsonLDObject)
    extends JsonLDObjectWrapper
    with UnwrappedFields {
  override type This = Documentation

  override protected def fields: Fields = wrapped.fields

  /** @return
    *   page unique identifier
    */
  def name: Option[String] = get[StrField](Name)

  /** @return
    *   page path/file name from where has been processed
    */
  def path: Option[String] = get[StrField](Path)

  def withName(name: String): Documentation = {
    wrapped.withProperty(Name, name)
    this
  }

  def withPath(path: String): Documentation = {
    wrapped.withProperty(Path, path)
    this
  }
}

object Documentation {
  def apply(name: String): Documentation = Documentation(JsonLDObject.empty(entityModel, JsonPath.empty)).withName(name)
}

object DocumentationModel {
  val Name: Field = Field(Str, Core + "name", doc("name"))

  val Path: Field = Field(Str, Data + "path", doc("path"))

  val `type`: List[ValueType] = List(Data + "Documentation")
  val fields: List[Field]     = List(Name, Path)

  private def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}
