package org.mulesoft.apb.project.client.platform.model.project

import amf.core.client.platform.model.document.BaseUnit
import org.mulesoft.apb.project.client.platform.model.management.APIInstance
import org.mulesoft.apb.project.client.platform.model.project.documentation.APIDocumentation
import org.mulesoft.apb.project.client.scala.model.project.{
  Project => InternalProject,
  ProjectDocument => InternalProjectDocument
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import org.mulesoft.apb.project.internal.convert.ManagementClientConverters.APIInstanceConverter

class ProjectDocument(private[apb] val _internal: InternalProjectDocument) {

  def this() = this(InternalProjectDocument())

  /** Encoded DomainElement described in the document element. */
  def encodes: ProjectInfo = _internal.encodes

}

case class Project(private[apb] val _internal: InternalProject) {

  def apiContract(): BaseUnit              = _internal.apiContract()
  def instances(): ClientList[APIInstance] = _internal.instances().asClient

  def documentation(): ClientList[APIDocumentation] = _internal.documentation().asClient

  // TODO native-jsonld : add properties of the descriptor
}
