package org.mulesoft.apb.project.client.scala.descriptor

import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.parser.DescriptorParserProviderCompanion

import scala.concurrent.Future

object DescriptorHandler extends DescriptorParserProviderCompanion {
  def apply() = new DescriptorHandler("")

  def apply(base: Option[String]) = new DescriptorHandler(base.getOrElse(""))

  override def getProvider: Option[String] => DescriptorParser = apply

  override val descriptorFileName: String = "exchange.json"
  override val projectProtocol: String    = "file:///"
}

case class DescriptorHandler private[apb] (base: String) extends DescriptorParser with DescriptorRender {

  def parse(content: String): DescriptorParseResult = new APBDescriptorParser(base).parse(content)

  def render(descriptor: ProjectDescriptor): String = APBDescriptorRender.render(descriptor)
}

trait DescriptorParser {
  def parse(content: String): DescriptorParseResult
}

trait DescriptorRender {
  def render(descriptor: ProjectDescriptor): String
}
