package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.model.{DateField, IntField, StrField}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel._
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel._
import org.mulesoft.apb.project.client.scala.model.descriptor.{Gav, GavAware}
import org.mulesoft.common.time.SimpleDateTime

trait ProjectBase extends UnwrappedFields with GavAware {

  private implicit def dependencyConversion(objs: Seq[JsonLDObject]): Seq[ProjectDependency] =
    objs.map(ProjectDependency.apply)

  def name(): String                         = get[StrField](ProjectDescriptorModel.Name)
  def gav(): Gav                             = getGav
  def classifier(): Option[String]           = get[StrField](Classifier)
  def tags(): Seq[String]                    = get[Seq[StrField]](Tags)
  def apiVersion(): Option[String]           = get[StrField](ApiVersion)
  def organizationId(): Option[String]       = get[StrField](OrganizationId)
  def dependencies(): Seq[ProjectDependency] = get[Seq[JsonLDObject]](Dependencies)

  def status(): Option[String]            = get[StrField](Status)
  def createdAt(): Option[SimpleDateTime] = get[DateField](CreatedAt)
  def createdBy(): Option[String]         = get[StrField](CreatedBy)
  def updatedAt(): Option[SimpleDateTime] = get[DateField](UpdatedAt)
  def customFields(): Seq[String]         = get[Seq[StrField]](CustomFields)
  def keyValueTags(): Seq[String]         = get[Seq[StrField]](KeyValueTags)
  def tenantId(): Option[String]          = get[StrField](TenantId)
  def categories(): Seq[String]           = get[Seq[StrField]](Categories)
  def `type`(): Option[String]            = get[StrField](TypeField)

  def majorVersionComponent(): Option[Int] = get[IntField](MajorVersionComponent)
  def minorVersionComponent(): Option[Int] = get[IntField](MinorVersionComponent)
  def patchVersionComponent(): Option[Int] = get[IntField](PatchVersionComponent)
  def apiId(): Option[String]              = get[StrField](ApiId)
  def projectType(): Option[String]        = get[StrField](ProjectType)

  private def getGav: Gav = {
    val groupId: String = get[StrField](GroupId)
    val assetId: String = get[StrField](AssetId)
    val version: String = get[StrField](Version)
    Gav(groupId, assetId, version)
  }
}
