package org.mulesoft.apb.project.client.scala.model.project.documentation

import amf.core.client.scala.model.StrField
import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.Str
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.DocumentationModel.Name
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.{Documentation, DocumentationModel}
import org.mulesoft.apb.project.client.scala.model.project.documentation.APIDocumentationModel.Content
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Api

class APIDocumentation(override private[apb] val wrapped: JsonLDObject) extends Documentation(wrapped) {

  def content: Option[String] = get[StrField](Name)

  def withContent(content: String): APIDocumentation = {
    wrapped.withProperty(Content, content)
    this
  }
}

object APIDocumentation {
  private[apb] def apply(jsonLDObject: JsonLDObject) = new APIDocumentation(jsonLDObject)

  private[apb] def apply(): APIDocumentation = {
    val path  = JsonPath.empty
    val model = JsonLDEntityModel(APIDocumentationModel.`type`, Nil, path)
    val init  = JsonLDObject.empty(model, path)
    new APIDocumentation(init)
  }

  def apply(path: String): APIDocumentation = apply().withPath(path)
}

object APIDocumentationModel extends DocumentationModel {

  val Content: Field = Field(Str, Data + "content", doc("Content"))

  override def `type`: List[ValueType] = List(Api + "APIDocumentation")

  override def fields: List[Field] = super.fields :+ Content
}
