package org.mulesoft.apb.project.internal.generated

object DescriptorSchema {

  def schema: String = """{
                         |  "$schema": "https://json-schema.org/draft-07/schema",
                         |  "@context": {
                         |    "@base": "http://a.ml/vocabularies/data#",
                         |    "core": "http://a.ml/vocabularies/core#",
                         |    "anypoint": "http://anypoint.com/vocabs/anypoint#",
                         |    "api": "http://anypoint.com/vocabs/api#",
                         |    "catalog": "http://anypoint.com/vocabs/digital-repository#",
                         |    "data": "http://a.ml/vocabularies/data#",
                         |    "name": "core:name",
                         |    "scope": "anypoint:scope",
                         |    "provided": "anypoint:provided",
                         |    "instances": "api:instance",
                         |    "dependencies": "catalog:dependency",
                         |    "organizationId": "anypoint:organizationId",
                         |    "branchId": "data:branchId",
                         |    "projectId": "data:projectId",
                         |    "commitId": "data:commitId",
                         |    "groupId": "catalog:groupId",
                         |    "assetId": "catalog:assetId",
                         |    "version": "catalog:semverVersion",
                         |    "gcl": "data:gcl",
                         |    "definedBy": "data:definedBy",
                         |    "classifier": "catalog:classifier",
                         |    "tags": "catalog:tags",
                         |    "tenantId": "anypoint:tenantId",
                         |    "majorVersionComponent": "catalog:majorVersionComponent",
                         |    "minorVersionComponent": "catalog:minorVersionComponent",
                         |    "patchVersionComponent": "catalog:patchVersionComponent",
                         |    "status": "catalog:status",
                         |    "createdBy": "anypoint:userId",
                         |    "createdAt": "core:dateCreated",
                         |    "updatedAt": "core:dateModified",
                         |    "type": "api:type",
                         |    "fields": "catalog:customFields",
                         |    "categories": "catalog:categories",
                         |    "keyValueTags": "catalog:keyValueTags",
                         |    "@type": "data:Descriptor",
                         |    "apiVersion": "api:apiVersion",
                         |    "apiId": "api:apiId"
                         |  },
                         |  "required": [
                         |    "main",
                         |    "name"
                         |  ],
                         |  "properties": {
                         |    "main": {
                         |      "type": "string"
                         |    },
                         |    "name": {
                         |      "type": "string"
                         |    },
                         |    "classifier": {
                         |      "type": "string"
                         |    },
                         |    "tags": {
                         |      "type": "array",
                         |      "items": {
                         |        "type": "string"
                         |      }
                         |    },
                         |    "organizationId": {
                         |      "type": "string"
                         |    },
                         |    "apiVersion": {
                         |      "type": "string"
                         |    },
                         |    "originalFormatVersion": {
                         |      "type": "string"
                         |    },
                         |    "metadata": {
                         |      "$ref": "#/definitions/Metadata"
                         |    },
                         |    "backwardsCompatible": {
                         |      "type": "boolean"
                         |    },
                         |    "publishWithRefFiles": {
                         |      "type": "boolean"
                         |    },
                         |    "description": {
                         |      "type": "string"
                         |    },
                         |    "projectId": {
                         |      "type": "string"
                         |    },
                         |    "tenantId": {
                         |      "type": "string"
                         |    },
                         |    "majorVersionComponent": {
                         |      "type": "integer"
                         |    },
                         |    "minorVersionComponent": {
                         |      "type": "integer"
                         |    },
                         |    "patchVersionComponent": {
                         |      "type": "integer"
                         |    },
                         |    "status": {
                         |      "type": "string"
                         |    },
                         |    "type": {
                         |      "type": "string"
                         |    },
                         |    "fields": {
                         |      "type": "array",
                         |      "items": {
                         |        "type": "string"
                         |      }
                         |    },
                         |    "categories": {
                         |      "type": "array",
                         |      "items": {
                         |        "type": "string"
                         |      }
                         |    },
                         |    "keyValueTags": {
                         |      "type": "array",
                         |      "items": {
                         |        "type": "string"
                         |      }
                         |    },
                         |    "createdAt": {
                         |      "type": "string",
                         |      "format": "date-time"
                         |    },
                         |    "updatedAt": {
                         |      "type": "string",
                         |      "format": "date-time"
                         |    },
                         |    "createdBy": {
                         |      "type": "string"
                         |    },
                         |    "apiId": {
                         |      "type": "string"
                         |    },
                         |    "projectType": {
                         |      "type": "string"
                         |    }
                         |  },
                         |  "oneOf": [
                         |    {
                         |      "$ref": "#/definitions/Gav"
                         |    }
                         |  ],
                         |  "if": {
                         |    "required": [
                         |      "descriptorVersion"
                         |    ],
                         |    "properties": {
                         |      "descriptorVersion": {
                         |        "not": {
                         |          "const": "0.1.0"
                         |        }
                         |      }
                         |    }
                         |  },
                         |  "then": {
                         |    "@context": {
                         |      "api": "http://anypoint.com/vocabs/api#",
                         |      "catalog": "http://anypoint.com/vocabs/digital-repository#",
                         |      "instances": "api:instance",
                         |      "dependencies": "catalog:dependency"
                         |    },
                         |    "required": [
                         |      "descriptorVersion"
                         |    ],
                         |    "properties": {
                         |      "descriptorVersion": {
                         |        "const": "1.0.0"
                         |      },
                         |      "dependencies": {
                         |        "type": "array",
                         |        "items": {
                         |          "$ref": "#/definitions/ProjectDependency"
                         |        }
                         |      },
                         |      "instances": {
                         |        "type": "array",
                         |        "items": {
                         |          "$ref": "#/definitions/Gcl"
                         |        }
                         |      },
                         |      "documentation": {
                         |        "type": "array",
                         |        "items": {
                         |          "$ref": "#/definitions/Documentation"
                         |        }
                         |      }
                         |    }
                         |  },
                         |  "else": {
                         |    "properties": {
                         |      "descriptorVersion": {
                         |        "const": "0.1.0"
                         |      },
                         |      "dependencies": {
                         |        "type": "array",
                         |        "items": {
                         |          "$ref": "#/definitions/LegacyProjectDependency"
                         |        }
                         |      }
                         |    }
                         |  },
                         |  "definitions": {
                         |    "LegacyProjectDependency": {
                         |      "@context": {
                         |        "catalog": "http://anypoint.com/vocabs/digital-repository#",
                         |        "@type": "catalog:Version"
                         |      },
                         |      "oneOf": [
                         |        {
                         |          "$ref": "#/definitions/Gav"
                         |        }
                         |      ],
                         |      "properties": {
                         |        "scope": {
                         |          "type": "string"
                         |        }
                         |      }
                         |    },
                         |    "ManagementDependency": {
                         |      "allOf": [
                         |        {
                         |          "properties": {
                         |            "scope": {
                         |              "enum": ["management"]
                         |            }
                         |          }
                         |        },
                         |        {
                         |          "$ref": "#/definitions/ProjectDependency"
                         |        }
                         |      ]
                         |    },
                         |    "ProjectDependency": {
                         |      "@context": {
                         |        "catalog": "http://anypoint.com/vocabs/digital-repository#",
                         |        "@type": "catalog:Version"
                         |      },
                         |      "oneOf": [
                         |        {
                         |          "$ref": "#/definitions/Gav"
                         |        }
                         |      ],
                         |      "properties": {
                         |        "scope": {
                         |          "type": "string",
                         |          "enum": [
                         |            "design",
                         |            "validation",
                         |            "design-extension",
                         |            "management"
                         |          ]
                         |        },
                         |        "provided": {
                         |          "type": "boolean"
                         |        }
                         |      }
                         |    },
                         |    "Metadata": {
                         |      "@context": {
                         |        "data": "http://a.ml/vocabularies/data#",
                         |        "branchId": "data:branchId",
                         |        "projectId": "data:projectId",
                         |        "commitId": "data:commitId"
                         |      },
                         |      "properties": {
                         |        "branchId": {
                         |          "type": "string"
                         |        },
                         |        "commitId": {
                         |          "type": "string"
                         |        },
                         |        "projectId": {
                         |          "type": "string"
                         |        }
                         |      }
                         |    },
                         |    "Gav": {
                         |      "@context": {
                         |        "catalog": "http://anypoint.com/vocabs/digital-repository#",
                         |        "groupId": "catalog:groupId",
                         |        "assetId": "catalog:assetId",
                         |        "version": "catalog:semverVersion"
                         |      },
                         |      "required": ["groupId", "assetId", "version"],
                         |      "properties": {
                         |        "groupId": {
                         |          "type": "string"
                         |        },
                         |        "assetId": {
                         |          "type": "string"
                         |        },
                         |        "version": {
                         |          "type": "string"
                         |        }
                         |      }
                         |    },
                         |    "Gcl": {
                         |      "@context": {
                         |        "data": "http://a.ml/vocabularies/data#",
                         |        "gcl": "data:gcl",
                         |        "definedBy": "data:definedBy"
                         |      },
                         |      "required": [
                         |        "gcl"
                         |      ],
                         |      "properties": {
                         |        "gcl": {
                         |          "type": "string"
                         |        },
                         |        "definedBy": {
                         |          "type": "string"
                         |        },
                         |        "dependencies": {
                         |          "type": "array",
                         |          "items": {
                         |            "$ref": "#/definitions/ProjectDependency"
                         |          }
                         |        }
                         |      }
                         |    },
                         |    "Documentation": {
                         |      "@context": {
                         |        "data": "http://a.ml/vocabularies/data#"
                         |      },
                         |      "required": [
                         |        "name",
                         |        "path"
                         |      ],
                         |      "properties": {
                         |        "path": {
                         |          "type": "string"
                         |        },
                         |        "name": {
                         |          "type": "string"
                         |        }
                         |      }
                         |    }
                         |  }
                         |}""".stripMargin
}
