package org.mulesoft.apb.project.client.platform.model.project.documentation

import org.mulesoft.apb.project.client.platform.model.descriptor.documentation.Documentation
import org.mulesoft.apb.project.client.scala.model.project.documentation.{APIDocumentation => InternalAPIDocumentation}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class APIDocumentation private[apb] (override private[apb] val _internal: InternalAPIDocumentation)
    extends Documentation(_internal) {

  @JSExportTopLevel("APIDocumentation")
  def this(path: String) = this(InternalAPIDocumentation(path))

  def content(): ClientOption[String] = _internal.content.asClient

  def withContent(content: String): APIDocumentation = {
    _internal.withContent(content)
    this
  }

}
