package org.mulesoft.apb.project.client.scala.descriptor

import amf.core.client.common.validation.ValidationMode
import amf.core.client.scala.validation.{AMFValidationReport, AMFValidationResult}
import amf.core.internal.remote.Mimes
import amf.shapes.client.scala.ShapesConfiguration
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.generated.DescriptorSchemaLoader
import org.mulesoft.apb.project.internal.parser.SyncJsonLdSchemaParser

class APBDescriptorParser(base: String) {

  def parse(content: String): DescriptorParseResult = {
    val (obj, errors) = SyncJsonLdSchemaParser.parse(DescriptorSchemaLoader.doc, content)
    val report        = validate(content)
    val finalReport   = report.copy(results = unique(report.results ++ errors))
    val descriptor    = ProjectDescriptor(obj, base)
    DescriptorParseResult(descriptor, finalReport)
  }

  private def unique(seq: Seq[AMFValidationResult]) = seq.distinct

  private def validate(content: String) = {
    ShapesConfiguration
      .predefined()
      .elementClient()
      .payloadValidatorFor(DescriptorSchemaLoader.schema, Mimes.`application/json`, ValidationMode.StrictValidationMode)
      .syncValidate(content)
  }
}

case class DescriptorParseResult(descriptor: ProjectDescriptor, report: AMFValidationReport)
