package org.mulesoft.apb.project.client.scala.gcl

import amf.core.client.scala.model.domain.DomainElement
import amf.shapes.client.scala.model.domain.SemanticContext
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.instances.APIInstanceModel.{POLICIES_FIELD_TERM, SPEC_CLASS_TERM}
import org.mulesoft.apb.project.client.scala.gcl.GraphOps._

case class ApiInstance(inner: JsonLDObject) {

  private val SPEC_IRI             = SemanticContext.baseIri + "spec"
  private val METADATA_IRI         = SemanticContext.baseIri + "metadata"
  private val NAME_IRI             = SemanticContext.baseIri + "metadata/name"
  private val LABELS_IRI           = SemanticContext.baseIri + "metadata/labels"
  private val INSTANCE_ID_IRI      = SemanticContext.baseIri + "metadata/labels/mulesoft.com/apiinstance-id"
  private val ENVIRONMENT_ID_IRI   = SemanticContext.baseIri + "metadata/labels/mulesoft.com/environment-id"
  private val POLICIES_IRI: String = POLICIES_FIELD_TERM.iri()

  def instanceId: Option[String]    = labels.flatMap(string(INSTANCE_ID_IRI))
  def environmentId: Option[String] = labels.flatMap(string(ENVIRONMENT_ID_IRI))
  def name: Option[String]          = metadata.flatMap(string(NAME_IRI))
  def spec: Option[JsonLDObject]    = obj(SPEC_IRI)(inner).collect { case jsonld: JsonLDObject => jsonld }

  def addPolicies(policies: List[JsonLDObject]): JsonLDObject = {
    val current          = spec.getOrElse(defaultSpec())
    val existingPolicies = objList(POLICIES_IRI)(current).collect { case jsonld: JsonLDObject => jsonld }
    val nextSpec         = current.withObjPropertyCollection(POLICIES_IRI, existingPolicies ++ policies)
    inner.withProperty(SPEC_IRI, nextSpec)
  }
  private def metadata: Option[DomainElement] = obj(METADATA_IRI)(inner)
  private def labels: Option[DomainElement]   = metadata.flatMap(obj(LABELS_IRI))

  private def defaultSpec() =
    JsonLDObject.empty(JsonLDEntityModel(List(SPEC_CLASS_TERM), Nil, JsonPath.empty), JsonPath.empty)
}
