package org.mulesoft.apb.project.internal.instances

import amf.core.client.scala.model.domain.DomainElement
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import amf.shapes.client.scala.model.domain.jsonldinstance.{JsonLDElement, JsonLDObject}
import org.mulesoft.apb.project.client.scala.gcl.{ApiInstance, PolicyBinding}
import org.mulesoft.apb.project.client.scala.instances.APIInstanceModel.{API_INSTANCE_TERM, POLICY_BINDING_TERM}

case class ResourceCatalog(instances: List[JsonLDInstanceDocument]) {
  private val resourcesIndex: Map[ResourceKind, List[JsonLDInstanceDocument]] = catalogResources()

  def getPolicyBindings: List[PolicyBinding] = {
    getResource(ResourceKind.PolicyBinding)
      .map(PolicyBinding)
      .filter(_.targetRefName.isDefined)
  }

  def getApiInstances: List[ApiInstance] = {
    getResource(ResourceKind.ApiInstance)
      .map(ApiInstance)
  }

  private def getResource(kind: ResourceKind) = {
    resourcesIndex
      .get(kind)
      .toList
      .flatten
      .flatMap(getEncoded)
  }

  private def getEncoded(document: JsonLDInstanceDocument) = {
    document.encodes.collectFirst { case jsonLdObject: JsonLDObject => jsonLdObject }
  }

  private def catalogResources(): Map[ResourceKind, List[JsonLDInstanceDocument]] = instances.groupBy(getResourceKind)

  private def getResourceKind(document: JsonLDInstanceDocument): ResourceKind = {
    if (document.encodes.length == 1) getResourceKind(document.encodes.head)
    else ResourceKind.Other
  }

  private def getResourceKind(element: JsonLDElement) = element match {
    case e: DomainElement if isApiInstanceNode(e)   => ResourceKind.ApiInstance
    case e: DomainElement if isPolicyBindingNode(e) => ResourceKind.PolicyBinding
    case _                                          => ResourceKind.Other
  }

  private def isApiInstanceNode(encodes: DomainElement) = encodes.meta.typeIris.contains(API_INSTANCE_TERM.iri())

  private def isPolicyBindingNode(encodes: DomainElement) = encodes.meta.typeIris.contains(POLICY_BINDING_TERM.iri())
}
