package org.mulesoft.apb.project.client.scala.model

import amf.core.client.common.validation.{ProfileName, ProfileNames}
import amf.core.client.scala.AMFResult
import amf.core.client.scala.model.document.{BaseUnit, ExternalFragment}
import amf.core.client.scala.model.domain.ExternalDomainElement
import amf.core.client.scala.validation.{AMFValidationReport, AMFValidationResult}
import amf.core.internal.remote.Spec.AMF
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import org.mulesoft.apb.project.client.scala.model.project.Project

abstract class BuildResult[+T](result: T, report: AMFValidationReport)

case class BaseUnitBuildResult(result: BaseUnit, report: AMFValidationReport)
    extends BuildResult[BaseUnit](result, report)

object BaseUnitBuildResult {
  private def profile(unit: BaseUnit) = ProfileName(spec(unit).id)
  private def spec(unit: BaseUnit)    = unit.sourceSpec.getOrElse(AMF)

  def apply(result: AMFResult): BaseUnitBuildResult = {
    val report = AMFValidationReport(result.baseUnit.id, profile(result.baseUnit), result.results)
    BaseUnitBuildResult(result.baseUnit, report)
  }

  def apply(unit: BaseUnit): BaseUnitBuildResult = {
    val report = AMFValidationReport.empty(unit.id, profile(unit))
    BaseUnitBuildResult(unit, report)
  }

  def apply(error: AMFValidationResult): BaseUnitBuildResult = {
    val unit   = ExternalFragment().withId("amf://error").withEncodes(ExternalDomainElement())
    val report = AMFValidationReport(unit.id, ProfileName(AMF.id), Seq(error))
    BaseUnitBuildResult(unit, report)
  }
}

case class ProjectBuildResult(result: Project, report: AMFValidationReport) extends BuildResult[Project](result, report)

object ProjectBuildResult {
  def apply(element: Project, id: String, errors: Seq[AMFValidationResult]): ProjectBuildResult = {
    val report = AMFValidationReport(id, ProfileNames.AMF, errors)
    ProjectBuildResult(element, report)
  }
}

case class JsonLDInstanceDocumentBuildResult(result: JsonLDInstanceDocument, report: AMFValidationReport)
    extends BuildResult[JsonLDInstanceDocument](result, report)
