package org.mulesoft.apb.project.client.scala.environment

import amf.core.client.common.remote.Content
import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.project.internal.idadoption.URITools._
import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

case class ProjectRelativeRL(path: String) extends ResourceLoader with PlatformSecrets {

  /** Fetch specified resource and return associated content. Resource should have been previously accepted. If the
    * resource doesn't exists, it returns a failed future caused by a ResourceNotFound exception.
    */
  override def fetch(resource: String): Future[Content] = {

    platform
      .fetchContent(s"$path/${resource.stripProtocol}", AMFGraphConfiguration.predefined())
      .map(_.copy(url = resource))
  }

  /** Checks if the resource loader accepts the specified resource. */
  override def accepts(resource: String): Boolean = !resource.contains(path) && resource.nonEmpty
}
