package org.mulesoft.apb.project.client.platform.dependency

import amf.core.client.platform.model.document.BaseUnit
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.dependency.{
  DesignDependency => InternalDesignDependency,
  ExtensionDependency => InternalExtensionDependency,
  ParsedDependency => InternalParsedDependency,
  ProfileDependency => InternalProfileDependency
}
import org.mulesoft.apb.project.client.scala.model.DependencyScope
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
abstract class ParsedDependency private[apb] (private[apb] val _internal: InternalParsedDependency) {
  val scope: DependencyScope        = _internal.scope
  val baseUnit: BaseUnit            = _internal.baseUnit
  val descriptor: ProjectDescriptor = _internal.descriptor
}

@JSExportAll
case class DesignDependency private[apb] (override private[apb] val _internal: InternalDesignDependency)
    extends ParsedDependency(_internal)

@JSExportAll
case class ExtensionDependency private[apb] (override private[apb] val _internal: InternalExtensionDependency)
    extends ParsedDependency(_internal)

@JSExportAll
case class ProfileDependency(override private[apb] val _internal: InternalProfileDependency)
    extends ParsedDependency(_internal) {
  val profileName: String = _internal.profileName
}
