package org.mulesoft.apb.project.client.platform.model

import amf.apicontract.internal.convert.ApiClientConverters.ClientOption
import org.mulesoft.apb.project.client.scala.model.{Metadata => InternalMetadata}

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

@JSExportAll
case class Metadata private[apb] (override private[apb] val _internal: InternalMetadata)
    extends JsonLDObjectWrapper(_internal) {

  @JSExportTopLevel("MetadataElement")
  def this() = this(InternalMetadata())

  def branchId(): ClientOption[String]  = _internal.branchId.asClient
  def commitId(): ClientOption[String]  = _internal.commitId.asClient
  def projectId(): ClientOption[String] = _internal.projectId.asClient

  def withBranchId(branchId: String): Metadata = {
    _internal.withBranchId(branchId)
    this
  }
  def withCommitId(commitId: String): Metadata = {
    _internal.withCommitId(commitId)
    this
  }
  def withProjectId(projectId: String): Metadata = {
    _internal.withProjectId(projectId)
    this
  }
}
