package org.mulesoft.apb.project.client.platform.model.descriptor.documentation

import amf.apicontract.internal.convert.ApiClientConverters.ClientOption
import org.mulesoft.apb.project.client.platform.model.JsonLDObjectWrapper
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.{Documentation => InternalDocumentation}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class Documentation private[apb] (override private[apb] val _internal: InternalDocumentation)
    extends JsonLDObjectWrapper(_internal) {

  @JSExportTopLevel("Documentation")
  def this(path: String) = this(InternalDocumentation(path))

  def name(): ClientOption[String] = _internal.name.asClient
  def path(): String               = _internal.path
  def order(): ClientOption[Int]   = _internal.order.asClient

  def withName(name: String): Documentation = {
    _internal.withName(name)
    this
  }
  def withPath(path: String): Documentation = {
    _internal.withPath(path)
    this
  }
  def withOrder(order: Int): Documentation = {
    _internal.withOrder(order)
    this
  }
}
