package org.mulesoft.apb.project.client.scala.instances

import amf.core.client.scala.adoption.IdAdopter
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import org.mulesoft.apb.project.client.scala.instances.inline.{InlineEnvironment, InlinePolicyBindings, InlineService}
import org.mulesoft.apb.project.client.scala.model.management.SchemaIris.{ORDER, PROPERTIES}
import org.mulesoft.apb.project.client.scala.model.management.{APIInstance, PolicyBinding, Service}
import org.mulesoft.apb.project.internal.instances.{ResourceCatalog, ScopedExtensionIndex}

import scala.language.implicitConversions

class APIInstanceBuilder(instances: List[JsonLDInstanceDocument], private val index: ScopedExtensionIndex) {

  private val catalog              = ResourceCatalog(instances)
  private val policyBindingInliner = InlinePolicyBindings(catalog.policiesIndex)
  private val serviceInliner       = InlineService(catalog.policiesIndex)
  private val environmentInliner   = InlineEnvironment(catalog.environmentIndex)
  // TODO: should we return a list of APIInstances here so an user can build instances independently????
  def build(): Seq[APIInstance] = {
    inlineServicesIntoPolicyBindings()
    val instances = catalog.getApiInstances.map { apiInstance =>
      inlinePolicyBindings(apiInstance)
      inlineEnvironments(apiInstance)
      inlineExtensions(apiInstance)
      apiInstance
    }
    instances
  }

  private def inlineServicesIntoPolicyBindings(): Unit = {
    catalog.getServices.foreach(inlineServices)
  }

  private def inlineExtensions(instance: APIInstance): Unit = {
    instance.policyBindings.foreach { binding =>
      inlineExtensions(binding)
    }
  }

  private def inlineExtensions(binding: PolicyBinding): Unit = {
    for {
      policyRefName <- binding.getPolicyRefName
      extension     <- index.findDefinitionFor(policyRefName)
    } yield {
      binding.withExtension(extension.extension, extension.gav)
      checkOrder(binding)
    }
  }

  private def checkOrder(binding: PolicyBinding) = {
    if (binding.spec.getScalarIfPresent[Int](ORDER).isEmpty) {
      // Analyze if it worth to have a Property object with the name and range of each property schema
      binding.withOrder(binding.extension.defaultOrder.getOrElse(0))
    }
  }

  private def inlineServices(service: Service): Unit            = serviceInliner.inlineInto(service)
  private def inlinePolicyBindings(instance: APIInstance): Unit = policyBindingInliner.inlineInto(instance)
  private def inlineEnvironments(instance: APIInstance): Unit   = environmentInliner.inlineInto(instance)
}
