package org.mulesoft.apb.project.client.scala.model.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.management.SchemaIris.{
  CORE,
  HEADERS,
  HOST,
  MANAGEMENT,
  METHOD,
  PATH,
  RichString
}

import scala.reflect.ClassTag

case class PolicyBindingRule(private[apb] val internal: JsonLDObject)(implicit val ruleIdx: Int) extends DynamicObject {
  def path: String                          = getScalar[String](PATH)
  def withPath(path: String): this.type     = withProperty(PATH, path)
  def method: String                        = getScalar[String](METHOD)
  def withMethod(method: String): this.type = withProperty(METHOD, method)
  def host: String                          = getScalar[String](HOST)
  def withHost(host: String): this.type     = withProperty(HOST, host)
  def getHeader[T](name: String)(implicit ct: ClassTag[T]): T = {
    val headers = getObject(HEADERS)
    headers.getScalar[T](s"$MANAGEMENT#$name")
  }
  def addHeader(name: String, value: String): this.type = {
    update(HEADERS) { headerObj =>
      headerObj.withProperty(s"$MANAGEMENT#$name", value)
    }
  }

  def addHeader(name: String, value: Int): this.type = {
    update(HEADERS) { headerObj =>
      headerObj.withProperty(s"$MANAGEMENT#$name", value)
    }
  }

  def addHeader(name: String, value: Float): this.type = {
    update(HEADERS) { headerObj =>
      headerObj.withProperty(s"$MANAGEMENT#$name", value)
    }
  }

  def addHeader(name: String, value: Double): this.type = {
    update(HEADERS) { headerObj =>
      headerObj.withProperty(s"$MANAGEMENT#$name", value)
    }
  }

  def addHeader(name: String, value: Boolean): this.type = {
    update(HEADERS) { headerObj =>
      headerObj.withProperty(s"$MANAGEMENT#$name", value)
    }
  }
}

object PolicyBindingRule {
  def apply(path: String, method: String, host: String)(implicit ruleIdx: Int): PolicyBindingRule = {
    val model = SchemaIris.PATH.toModel
    val init  = JsonLDObject.empty(model, model.path)
    PolicyBindingRule(init)
      .withPath(path)
      .withMethod(method)
      .withHost(host)
  }
}
