package org.mulesoft.apb.project.internal.generated

import amf.core.client.scala.AMFResult
import amf.core.client.scala.model.domain.Shape
import amf.core.client.scala.validation.AMFValidationResult
import amf.shapes.client.scala.model.document.JsonSchemaDocument
import org.mulesoft.apb.project.internal.parser.SyncJsonSchemaCompiler

object DescriptorSchemaLoader {

  val LegacyVersion = "0.1.0"

  val parsed: AMFResult                = SyncJsonSchemaCompiler.compile(DescriptorSchema.schema)
  val doc: JsonSchemaDocument          = parsed.baseUnit.asInstanceOf[JsonSchemaDocument]
  def schema: Shape                    = doc.encodes
  def errors: Seq[AMFValidationResult] = parsed.results
}
