package org.mulesoft.apb.project.client.platform

import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.project.client.platform.environment.DependencyFetcher
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.{ProjectConfigurationBuilder => InternalProjectBuilder}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class ProjectConfigurationBuilder private[apb](private[apb] val _internal: InternalProjectBuilder) {

  @JSExportTopLevel("ProjectBuilder")
  def this(dependencyFetcher: DependencyFetcher, loaders: ClientList[ResourceLoader]) =
    this(InternalProjectBuilder(dependencyFetcher, loaders.asInternal.toList))

  def build(project: ProjectDescriptor): ClientFuture[ProjectConfiguration] = _internal.build(project).asClient

  def buildFromDirectory(directory: String): ClientFuture[ProjectConfiguration] =
    _internal.buildFromDirectory(directory).asClient

  def buildFromContent(
      descriptorAsString: String
  ): ClientFuture[ProjectConfiguration] =
    _internal.buildFromContent(descriptorAsString).asClient
}
