package org.mulesoft.apb.project.client.platform.model.project.management

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.project.management.{PolicyBindingRule => InternalPolicyBindingRule}

import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class PolicyBindingRule(override private[apb] val internal: InternalPolicyBindingRule) extends DynamicObject(internal) {
  def path: String = internal.path
  def withPath(path: String): this.type = {
    internal.withPath(path)
    this
  }
  def method: String = internal.method
  def withMethod(method: String): this.type = {
    internal.withMethod(method)
    this
  }
  def host: String = internal.host
  def withHost(host: String): this.type = {
    internal.withHost(host)
    this
  }
  def getStringHeader(name: String): String   = internal.getHeader[String](name)
  def getIntHeader(name: String): Int         = internal.getHeader[Int](name)
  def getFloatHeader(name: String): Float     = internal.getHeader[Float](name)
  def getDoubleHeader(name: String): Double   = internal.getHeader[Double](name)
  def getBooleanHeader(name: String): Boolean = internal.getHeader[Boolean](name)

  def addHeader(name: String, value: String): this.type = {
    internal.addHeader(name, value)
    this
  }

  def addHeader(name: String, value: Int): this.type = {
    internal.addHeader(name, value)
    this
  }

  def addHeader(name: String, value: Float): this.type = {
    internal.addHeader(name, value)
    this
  }

  def addHeader(name: String, value: Double): this.type = {
    internal.addHeader(name, value)
    this
  }

  def addHeader(name: String, value: Boolean): this.type = {
    internal.addHeader(name, value)
    this
  }
}
