package org.mulesoft.apb.project.client.scala.model.project.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.Gav
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{
  ADDRESS,
  CORE,
  DEFAULT,
  EXTENDS,
  NAME,
  ORDER,
  PROPERTIES,
  ROUTES,
  RichString,
  SPEC
}

case class Extension(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with HasName
    with HasSpec
    with HasLabels {
  def `extends`: Seq[String] =
    specIfPresent.toList.flatMap(_.getObjectArray(EXTENDS).flatMap(_.getScalarIfPresent[String](NAME)))

  def withGav(gav: Gav) = {
    addLabel("mulesoft.com/groupId", gav.groupId)
    addLabel("mulesoft.com/assetId", gav.assetId)
    addLabel("mulesoft.com/version", gav.version)
  }

  def defaultOrder: Option[Int] = {
    specIfPresent
      .flatMap(_.getObjectIfPresent(PROPERTIES))
      .flatMap(_.getObjectIfPresent(ORDER))
      .flatMap(_.getScalarIfPresent[Int](DEFAULT))
  }
}
