package org.mulesoft.apb.project.client.scala.model.project.management

import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath

object SchemaIris {
  // namespaces
  val CORE         = "http://a.ml/vocabularies/core"
  val MANAGEMENT   = "http://anypoint.com/vocabs/management"
  val MULESOFT_COM = "http://mulesoft.com"

  // instance & policy bindings
  val EXTENDS                = s"$MANAGEMENT#extends"
  val SPEC                   = s"$MANAGEMENT#spec"
  val METADATA               = s"$MANAGEMENT#metadata"
  val POLICIES               = s"$MANAGEMENT#policies"
  val INSTANCE_ADDRESS       = s"$MANAGEMENT#address"
  val SERVICE                = s"$MANAGEMENT#service"
  val POLICY_REF             = s"$MANAGEMENT#policyRef"
  val IMPLEMENTED_BY         = s"$MANAGEMENT#implementedBy"
  val DEFINITION             = s"$MANAGEMENT#definition"
  val TARGET_REF             = s"$MANAGEMENT#targetRef"
  val CONFIG                 = s"$MANAGEMENT#config"
  val POLICY_BINDING_RULES   = s"$MANAGEMENT#rules"
  val ORDER                  = s"$MANAGEMENT#order"
  val NAME                   = s"$CORE#name"
  val NAMESPACE              = s"$MANAGEMENT#namespace"
  val LABELS                 = s"$MANAGEMENT#labels"
  val ANNOTATIONS            = s"$MANAGEMENT#annotations"
  val ENVIRONMENT_KIND       = s"$MANAGEMENT#environmentKind"
  val ENVIRONMENT            = s"$MANAGEMENT#environment"
  val ADDRESS                = s"$MANAGEMENT#address"
  val ROUTES                 = s"$MANAGEMENT#routes"
  val RULES                  = s"$MANAGEMENT#rules"
  val DESTINATION_PATH       = s"$MANAGEMENT#destinationPath"
  val DESTINATION_REF        = s"$MANAGEMENT#destinationRef"
  val PATH                   = s"$MANAGEMENT#path"
  val ENVIRONMENT_TARGET_REF = s"$MANAGEMENT#targetEnvironmentRef"

  // policies
  val NAMED_REF_KIND = s"$MANAGEMENT#kind"
  val METHOD         = s"$MANAGEMENT#method"
  val HOST           = s"$MANAGEMENT#host"
  val HEADERS        = s"$MANAGEMENT#headers"

  // labels
  val API_INSTANCE_ID_LABEL    = s"$MANAGEMENT#mulesoft.com/apiinstance-id"
  val API_INSTANCE_LABEL_LABEL = s"$MANAGEMENT#mulesoft.com/apiinstance-label"

  // Extensions
  val PROPERTIES = s"$MANAGEMENT#properties"
  val DEFAULT    = s"$MANAGEMENT#default"

  implicit class RichString(str: String) {
    def toJsonPath: JsonPath = {
      val idx = str.indexOf("#")
      val segments = str
        .substring(idx + 1) // remove namespace
        .split("/")
        .toList
      JsonPath(segments)
    }

    def toStrField: Field = Field(amf.core.internal.metamodel.Type.Str, toValueType)

    def toIntField: Field = Field(amf.core.internal.metamodel.Type.Int, toValueType)

    def toObjField: Field = Field(amf.core.internal.metamodel.Type.ObjType, toValueType)

    def toValueType: ValueType = ValueType(str)

    def toModel: JsonLDEntityModel = {
      val path  = str.toJsonPath
      val type_ = str.toValueType
      JsonLDEntityModel(List(type_), Nil, path)
    }

  }
}

object Constants {
  def apiVersion: String             = "gateway.mulesoft.com/v1alpha1"
  def apiInstanceKind: String        = "ApiInstance"
  def policyBindingKind: String      = "PolicyBinding"
  def serviceKind: String            = "Service"
  def environmentKind: String        = "Environment"
  def environmentBindingKind: String = "EnvironmentBinding"
}
