package org.mulesoft.apb.project.client.scala.model.project.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.DynamicObject._
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{
  CONFIG,
  DESTINATION_PATH,
  PATH,
  ROUTES,
  RULES
}

case class ServiceRoute(private[apb] val internal: JsonLDObject)(implicit val serviceName: String, routeIndex: Int)
    extends DynamicObject {

  def rules: Seq[String] = {
    val rules = getObjectArray(RULES)
    rules.zipWithIndex
      .map { case (rule, ruleIndex) =>
        rule.getScalar[String](PATH)
      }
  }

  def addRule(rule: String): this.type = {
    withRules(rules :+ rule)
  }
  def withRules(rules: Seq[String]): this.type = {
    val ruleObjects = rules.zipWithIndex
      .map { case (rule, ruleIndex) =>
        DynamicObject(RULES).withProperty(PATH, rule)
      }
    withProperty(RULES, ruleObjects)
  }
  def destinationPath: String = {
    val config = getObject(CONFIG)
    config.getScalar[String](DESTINATION_PATH)
  }

  def withDestinationPath(destinationPath: String): this.type = {
    update(CONFIG) { config =>
      config.withProperty(DESTINATION_PATH, destinationPath)
    }
  }

}

object ServiceRoute {
  def apply(destinationPath: String)(implicit serviceName: String, routeIndex: Int): ServiceRoute = {
    ServiceRoute(toJsonLDObject(DynamicObject(ROUTES)))
      .withDestinationPath(destinationPath)
  }
}
