package org.mulesoft.apb.project.internal.metamodel

import amf.core.client.scala.vocabulary.{Namespace, ValueType}
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.document.FragmentModel
import amf.core.internal.metamodel.domain.{ModelDoc, ModelVocabularies}
import org.mulesoft.apb.project.client.scala.model.project.ProjectDocument

object ProjectDocumentModel extends FragmentModel {

  override def modelInstance: ProjectDocument = ProjectDocument()

  override val doc: ModelDoc = ModelDoc(
      ModelVocabularies.AmlDoc,
      "ProjectDocument",
      "A Project is a Unit that encodes a while api project element"
  )

  override val `type`: List[ValueType] = List(Namespace.Document + "ProjectDocument") ++ FragmentModel.`type`

  override val fields: List[Field] = FragmentModel.fields
}
