package org.mulesoft.apb.project.client.scala.instances.inline

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.instances.APIInstanceModel.TARGET_REF_FIELD_TERM
import org.mulesoft.apb.project.client.scala.model.project.management.{APIInstance, PolicyBinding}
import org.mulesoft.apb.project.internal.instances.PolicyBindingIndex

case class InlinePolicyBindings(index: PolicyBindingIndex) {

  def inlineInto(apiInstance: APIInstance): Unit = {
    val bindings = index.getBindingsFor(apiInstance)
    addPoliciesToInstance(bindings, apiInstance)
  }

  private def addPoliciesToInstance(bindings: Seq[PolicyBinding], apiInstance: APIInstance): JsonLDObject = {
    bindings.foreach(removePolicyRef)
    apiInstance.withPolicyBindings(bindings)
  }

  private def removePolicyRef(binding: PolicyBinding) = binding.spec.graph.removeField(TARGET_REF_FIELD_TERM.iri())
}
