package org.mulesoft.apb.project.client.scala.model.project.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{
  NAME,
  NAMESPACE,
  POLICY_REF,
  RichString
}

case class PolicyRef(override private[apb] val internal: JsonLDObject) extends DynamicObject {
  def name: String                                = getScalar[String](NAME)
  def withName(name: String): this.type           = withProperty(NAME, name)
  def namespace: String                           = getScalar[String](NAMESPACE)
  def withNamespace(namespace: String): this.type = withProperty(NAMESPACE, namespace)
}

object PolicyRef {
  def apply(name: String): PolicyRef = {
    val model = POLICY_REF.toModel
    val init  = JsonLDObject.empty(model, model.path)
    PolicyRef(init)
      .withName(name)
  }
}
