package org.mulesoft.apb.project.internal.view

import amf.core.client.scala.model.domain.{AmfObject, DomainElement}
import amf.core.client.scala.vocabulary.Namespace.Document
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.{Field, ModelDefaultBuilder, Obj}
import amf.core.internal.parser.domain.{Annotations, Fields}
import org.mulesoft.apb.project.internal.view.GraphObjectCopier.defaultIgnoredTypes

trait AmfObjectElementCopier {

  def copy(obj: AmfObject): AmfObject
}

object GraphObjectCopier {
  def defaultIgnoredTypes: Set[ValueType] = Set(Document + "JsonLDObject")
}

case class GraphObjectCopier(
    mappings: Map[ValueType, List[ValueType]],
    ignoreTypes: Set[ValueType] = defaultIgnoredTypes
) extends AmfObjectElementCopier {
  override def copy(obj: AmfObject): AmfObject = {
    val extraTypes = obj.meta.`type`.headOption.flatMap(mappings.get).getOrElse(List.empty).toSet
    GraphObject(obj, filterUnwanted(extraTypes).toList).withId(obj.id)
  }

  private def filterUnwanted(types: Set[ValueType]) = types -- ignoreTypes
}

case class GraphObject(inner: AmfObject, types: List[ValueType], fields: Fields = Fields()) extends DomainElement {
  override def meta: Obj = GraphObjectMeta(types ::: inner.meta.`type` , fields.fields().map(_.field).toList)

  override def componentId: String = inner.componentId

  override val annotations: Annotations = inner.annotations
}

case class GraphObjectMeta(`type`: List[ValueType],fields:List[Field]) extends Obj {
}

object AsIsElementCopier extends AmfObjectElementCopier {
  override def copy(obj: AmfObject): AmfObject = {
    obj.meta.asInstanceOf[ModelDefaultBuilder].modelInstance.asInstanceOf[DomainElement]
  }
}
