package org.mulesoft.apb.project.client.scala.model.project.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.instances.APIInstanceModel.ENVIRONMENT_BINDING_TERM
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{
  ENVIRONMENT_TARGET_REF,
  SPEC,
  TARGET_REF
}

case class EnvironmentBinding(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with HasTargetRef
    with HasName {
  def targetEnvironmentRef: String = spec.getScalar(ENVIRONMENT_TARGET_REF)

  def withTargetEnvironmentRef(name: String): this.type = {
    update(SPEC) { spec =>
      spec.withProperty(ENVIRONMENT_TARGET_REF, NamedRef(name, ENVIRONMENT_TARGET_REF))
    }
  }
}
object EnvironmentBinding {
  def apply(instanceRef: String, envRef: String): EnvironmentBinding = {
    val path  = JsonPath.empty
    val model = JsonLDEntityModel(List(ENVIRONMENT_BINDING_TERM), Nil, path)
    val init  = JsonLDObject.empty(model, path)
    EnvironmentBinding(init)
      .withProperty("http://a.ml/vocabularies/core#apiVersion", Constants.apiVersion)
      .withProperty("http://a.ml/vocabularies/core#kind", Constants.environmentBindingKind)
      .withTargetEnvironmentRef(envRef)
      .withTargetRef(instanceRef)
  }

  private[apb] def apply(internal: JsonLDObject) = new EnvironmentBinding(internal)
}
