package org.mulesoft.apb.project.internal.view

import amf.aml.internal.metamodel.document.DialectInstanceModel.DefinedBy
import amf.core.client.scala.vocabulary.{Namespace, ValueType}
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.document.DocumentModel
import org.mulesoft.apb.project.client.scala.extensions.EnvironmentExtension.ENVIRONMENT_IRI
import org.mulesoft.apb.project.client.scala.extensions.InstanceEnvironmentModel
import org.mulesoft.apb.project.client.scala.instances.APIInstanceModel.API_INSTANCE_TERM
import org.mulesoft.apb.project.client.scala.model.project.ProjectDocumentBuilder.INSTANCE_ID_IRI
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel.{AssetId, GroupId, Scope, Version, Classifier}
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel._
import org.mulesoft.apb.project.client.scala.model.descriptor.InstanceModel
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.RichString
import org.mulesoft.apb.project.client.scala.model.{ProjectDependencyModel, ProjectDescriptorModel}
import org.mulesoft.apb.project.internal.metamodel.ProjectInfoModel
import org.mulesoft.apb.project.internal.metamodel.ProjectInfoModel.{Contract, Instances}

object Views {

  type View = (ValueType, List[Field])

  private val projectView = ProjectInfoModel.`type`.head -> List(
      OrganizationId,
      Classifier,
      GroupId,
      AssetId,
      Version,
      MajorVersionComponent,
      MinorVersionComponent,
      PatchVersionComponent,
      Status,
      Tags,
      Categories,
      Instances,
      Dependencies,
      TenantId,
      CreatedAt,
      CreatedBy,
      UpdatedAt,
      TypeField,
      Name,
      ApiVersion,
      ApiId,
      ProjectType,
      ContactName,
      ContactEMail
//      Contract
  )

  private val apiContractView = DocumentModel.`type`.head -> List(
      DefinedBy
  )

  private val apiInstanceView = API_INSTANCE_TERM -> List(
      INSTANCE_ID_IRI,
      ENVIRONMENT_IRI,
      SchemaIris.METADATA.toObjField
  )

  private val metadataView: (ValueType, List[Field]) =
    SchemaIris.METADATA.toValueType -> List(SchemaIris.LABELS.toObjField)

  private val labelsView = SchemaIris.LABELS.toValueType -> List(
      SchemaIris.API_INSTANCE_ID_LABEL.toIntField,
      SchemaIris.API_INSTANCE_LABEL_LABEL.toStrField
  )

  private val dependencyView: (ValueType, List[Field]) = ProjectDependencyModel.`type`.head -> List(
      GroupId,
      AssetId,
      Version,
      Scope
  )

  private val environmentView: (ValueType, List[Field]) =
    InstanceEnvironmentModel.`type`.head -> InstanceEnvironmentModel.fields

  private val instancesDescriptorView = InstanceModel.`type`.head -> InstanceModel.fields
  val projectSummary: List[View] =
//    List(projectView, apiContractView, apiInstanceView, environmentView, dependencyView, metadataView, labelsView)
    List(projectView, apiInstanceView, environmentView, dependencyView, metadataView, labelsView)
  private val descriptorFieldsView: (ValueType, List[Field]) =
    ProjectDescriptorModel.`type`.head -> ProjectInfoModel.fields.filterNot(f =>
      List(Instances, Documentation).contains(f)
    )
  val descriptorView: List[View] =
    List(descriptorFieldsView, dependencyView, instancesDescriptorView, labelsView, metadataView)

  def mappings(schemaId: String) = {

    def valueType = (entity: String) => ValueType(Namespace(schemaId), s"#/declarations/${entity}")
    Map(
        ProjectInfoModel.`type`.head         -> List(valueType("APIProject")),
        InstanceEnvironmentModel.`type`.head -> List(valueType("Environment")),
        ProjectDependencyModel.`type`.head   -> List(valueType("Dependency")),
        API_INSTANCE_TERM                    -> List(valueType("APIInstance")),
        DocumentModel.`type`.head            -> List(valueType("Document"))
    )
  }
}
