package org.mulesoft.apb.project.client.platform

import amf.apicontract.client.platform.AMFConfiguration
import amf.core.client.platform.validation.AMFValidationResult
import amf.core.internal.remote.Spec
import org.mulesoft.apb.project.client.platform.dependency.{
  DesignDependency,
  ExtensionDependency,
  ParsedDependency,
  ProfileDependency
}
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.{ProjectConfiguration => InternalProjectConfiguration}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class ProjectConfiguration private[apb] (private[apb] val _internal: InternalProjectConfiguration) {

  val designDependencies: ClientList[DesignDependency]       = _internal.designDependencies.asClient
  val profileDependencies: ClientList[ProfileDependency]     = _internal.profileDependencies.asClient
  val extensionDependencies: ClientList[ExtensionDependency] = _internal.extensionDependencies.asClient
  val descriptor: ProjectDescriptor                          = _internal.descriptor
  val errors: ClientList[AMFValidationResult]                = _internal.errors.allErrors.asClient
  val allDependencies: ClientList[ParsedDependency]          = _internal.allDependencies.asClient
//  val classifierConfig: AMFConfiguration                     = _internal.classifierConfig()
//  def parseConfig: AMFConfiguration                          = _internal.apiParseConfig
//  def configFor(spec: Spec): AMFConfiguration                = _internal.configFor(spec)
}
