package org.mulesoft.apb.project.client.scala.environment

import amf.core.client.common.remote.Content
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.internal.dependency.ExchangeModulePathHandler

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

trait DependencyFetcher {

  final def wrapFetch(
      groupId: String,
      assetId: String,
      version: String,
      protocol: String,
      classifier: Option[String],
      packaging: Option[String]
  ): ResourceLoader = {
    val inner: ResourceLoader = fetch(groupId, assetId, version, classifier, packaging)
    new ResourceLoader {

      /** Fetch specified resource and return associated content. Resource should have been previously accepted. If the
        * resource doesn't exists, it returns a failed future caused by a ResourceNotFound exception.
        */
      override def fetch(resource: String): Future[Content] = {
        inner.fetch(resource).map { c =>
          val path = ExchangeModulePathHandler.buildPath(groupId, assetId, version, resource, protocol)
          c.copy(url = path)
        }
      }

      /** Checks if the resource loader accepts the specified resource. */
      override def accepts(resource: String): Boolean = inner.accepts(resource)
    }

  }

  // TODO: use ProjectDependency directly
  def accepts(groupId: String, assetId: String, version: String): Boolean
  def fetch(groupId: String, assetId: String, version: String): ResourceLoader

  def accepts(
      groupId: String,
      assetId: String,
      version: String,
      classifier: Option[String],
      packaging: Option[String]
  ): Boolean =
    accepts(groupId, assetId, version)
  def fetch(
      groupId: String,
      assetId: String,
      version: String,
      classifier: Option[String],
      packaging: Option[String]
  ): ResourceLoader =
    fetch(groupId, assetId, version)
}

@JSExportAll
@JSExportTopLevel("UnreachableGavError")
case class UnreachableGavException(message: String) extends Exception(message)
