package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.vocabulary.Namespace
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject

trait DynamicObject {
  type This <: DynamicObject

  private[apb] val wrapped: JsonLDObject
  private val namespace: Namespace = Namespace("http://anypoint.apb/vocabularies/dynamic#")

  def withDynamicProperty(key: String, value: String): This = {
    wrapped.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }

  def withDynamicProperty(key: String, value: Int): This = {
    wrapped.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }

  def withDynamicProperty(key: String, value: Boolean): This = {
    wrapped.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }

  def withDynamicProperty(key: String, value: Float): This = {
    wrapped.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }

  def withDynamicProperty(key: String, value: JsonLDObject): This = {
    wrapped.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }
}
