package org.mulesoft.apb.project.client.scala.model.descriptor

import amf.core.client.scala.model.StrField
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.internal.model.ProjectDescriptorModel.ProjectId
import org.mulesoft.apb.project.internal.model.descriptor.MetadataModel.{BranchId, CommitId, entityModel}
import org.mulesoft.apb.project.internal.model.UnwrappedFields

case class Metadata(override private[apb] val wrapped: JsonLDObject) extends DynamicObject with UnwrappedFields {

  override type This = Metadata

  override protected def fields: Fields = wrapped.fields

  def branchId: Option[String] = get[StrField](BranchId)

  def commitId: Option[String] = get[StrField](CommitId)

  def projectId: Option[String] = get[StrField](ProjectId)

  def withBranchId(branchId: String): Metadata = {
    wrapped.withProperty(BranchId, branchId)
    this
  }

  def withCommitId(commitId: String): Metadata = {
    wrapped.withProperty(CommitId, commitId)
    this
  }

  def withProjectId(projectId: String): Metadata = {
    wrapped.withProperty(ProjectId, projectId)
    this
  }
}

object Metadata {
  def apply(): Metadata = Metadata(JsonLDObject.empty(entityModel, JsonPath.empty))
}
