package org.mulesoft.apb.project.client.scala.model.descriptor.documentation

import amf.core.client.scala.model.{IntField, StrField}
import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.{Int, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.DocumentationModel.{
  Name,
  Order,
  Path,
  entityModel
}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Core
import org.mulesoft.apb.project.internal.model.UnwrappedFields

class Documentation(override private[apb] val wrapped: JsonLDObject) extends DynamicObject with UnwrappedFields {
  override type This = Documentation

  override protected def fields: Fields = wrapped.fields

  /** @return
    *   page unique identifier
    */
  def name: Option[String] = get[StrField](Name)

  /** @return
    *   page path/file name from where has been processed
    */
  def path: String       = get[StrField](Path)
  def order: Option[Int] = get[IntField](Order)

  def withName(name: String): this.type = {
    wrapped.withProperty(Name, name)
    this
  }

  def withPath(path: String): this.type = {
    wrapped.withProperty(Path, path)
    this
  }

  def withOrder(order: Int): this.type = {
    wrapped.withProperty(Order, order)
    this
  }
}

object Documentation {
  def apply(path: String): Documentation =
    Documentation.apply(JsonLDObject.empty(entityModel, JsonPath.empty)).withPath(path)

  private[apb] def apply(jsonLDObject: JsonLDObject): Documentation = new Documentation(jsonLDObject)
}

trait DocumentationModel {
  val Name: Field = Field(Str, Core + "name", doc("name"))

  val Path: Field = Field(Str, Data + "path", doc("path"))

  val Order: Field = Field(Int, Data + "order", doc("order"))

  def `type`: List[ValueType] = List(Data + "Documentation")
  def fields: List[Field]     = List(Name, Path, Order)

  protected def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

object DocumentationModel extends DocumentationModel
