package org.mulesoft.apb.project.internal.instances

import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{ENVIRONMENT, SPEC}
import org.mulesoft.apb.project.client.scala.model.project.management.{APIInstance, Environment}

case class InlineEnvironment(index: EnvironmentIndex) {

  def inlineInto(apiInstance: APIInstance): Unit = {
    // TODO: just an environment by api instance is possible. Check how to do validation when is necessary
    index.getEnvironmentFor(apiInstance).foreach { case (environment, _) =>
      addEnvironmentToInstance(apiInstance, environment)
    }
  }

  private def addEnvironmentToInstance(apiInstance: APIInstance, environment: Environment) = {
    apiInstance.update(SPEC) { spec =>
      spec.withProperty(ENVIRONMENT, environment)
    }
  }
}
