package org.mulesoft.apb.project.internal.ops

import scala.concurrent.{ExecutionContext, Future}
import scala.language.higherKinds
import scala.util.{Failure, Success}

object FutureOps {

  def filterSuccess[T](futures: Iterable[Future[T]])(implicit ec: ExecutionContext): Future[Iterable[T]] = {
    val futureTries = futures
      .map(x =>
        x.map(x => Success(x))
          .recover { case ex => Failure(ex) }
      )

    Future.sequence(futureTries).map {
      _.collect { case Success(result) =>
        result
      }
    }
  }

  implicit class Tap[A](future: Future[A]) {
    def tap(tapFunc: A => Unit)(implicit ec: ExecutionContext): Future[A] = future.map { something =>
      tapFunc(something)
      something
    }
  }
}
