package org.mulesoft.apb.project.internal.transformation

import amf.core.client.scala.transform.{TransformationPipeline, TransformationStep}
import org.mulesoft.apb.project.client.scala.ProjectConfiguration

case class APBTransformationPipeline(config: ProjectConfiguration, base: TransformationPipeline)
    extends TransformationPipeline {
  override val name: String = base.name

  override def steps: Seq[TransformationStep] = getApbSteps(config) ++ base.steps

  private def getApbSteps(config: ProjectConfiguration): Seq[TransformationStep] = {
    val base = Seq(new JSONDocumentRefCleaningTransformationStage())
    if (config.descriptor.isRaml)
      base ++ Seq(new CompanionLibCheckTransformationStage(fetchExtensionCompanions(config)))
    else base
  }

  private def fetchExtensionCompanions(config: ProjectConfiguration) = config.extensionDependencies
    .flatMap(_.companionLibDependency)
}
