package org.mulesoft.apb.project.client.scala

import amf.aml.client.scala.model.document.{Dialect, DialectInstance}
import amf.apb.internal.plugins.ApbFallbackPlugin
import amf.apicontract.client.scala._
import amf.apicontract.internal.transformation.UnsupportedTransformationPipeline
import amf.core.client.scala.adoption.IdAdopterProvider
import amf.core.client.scala.config.UnitCache
import amf.core.client.scala.resource.ResourceLoader
import amf.core.client.scala.transform.TransformationPipelineBuilder
import amf.core.internal.remote.Spec
import org.mulesoft.apb.project.client.scala.config.AMFConfigurationFactory
import org.mulesoft.apb.project.client.scala.dependency._
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.dependency.APBResourceLoader
import org.mulesoft.apb.project.internal.dependency.config.ConfigProvider
import org.mulesoft.apb.project.internal.engine.MigrationRisks
import org.mulesoft.apb.project.internal.idadoption.IdAdopterProvider
import org.mulesoft.apb.project.internal.listener.{
  AbsolutePathDetectionRawReferenceListener,
  InternalDependencyFileReferenceListener,
  RawReferenceListener
}
import org.mulesoft.apb.project.internal.transformation.{
  APBRaml10EditingPipeline,
  APBTransformationPipeline,
  JSONDocumentRefCleaningTransformationStage
}

case class ProjectConfiguration(
    designDependencies: Seq[DesignDependency],
    profileDependencies: Seq[ProfileDependency],
    extensionDependencies: Seq[ExtensionDependency],
    invalidDependencies: Seq[InvalidParsedDependency],
    dependencyLoaders: Map[String, ResourceLoader],
    descriptor: ProjectDescriptor,
    validationDialect: Dialect,
    unitCacheBuilder: UnitCacheBuilder = APBUnitCacheBuilder,
    envLoaders: List[ResourceLoader],
    errors: ProjectErrors,
    private[apb] val migrationRisks: MigrationRisks = MigrationRisks.empty
) extends DependencySet {

  def mainLoader(): ResourceLoader = new APBResourceLoader(dependencyLoaders)

  override def design(): Seq[DesignDependency]             = designDependencies
  override def validation(): Seq[ProfileDependency]        = profileDependencies
  override def designExtension(): Seq[ExtensionDependency] = extensionDependencies

  // TODO: WATCH OUT!! This is mutable
  lazy val absolutePathListener: Option[AbsolutePathDetectionRawReferenceListener] =
    AbsolutePathDetectionRawReferenceListener(descriptor)

  def getAnypointConfigListeners: Iterable[RawReferenceListener] =
    absolutePathListener ++ Seq(InternalDependencyFileReferenceListener(designDependencies))

  def getListeners(): Iterable[RawReferenceListener] =
    if (!descriptor.isLegacyDescriptor) getAnypointConfigListeners else Nil

  def mainFile: Option[String] = descriptor.main

  override def allDependencies(): Seq[ParsedDependency] =
    designDependencies ++ extensionDependencies ++ profileDependencies
}
