package org.mulesoft.apb.project.internal.instances

import org.mulesoft.apb.project.client.scala.model.project.management.{APIInstance, PolicyBinding, Service}

import scala.collection.mutable

object PolicyBindingIndex {
  def build(catalog: ResourceCatalog): PolicyBindingIndex = {
    val bindings            = catalog.getPolicyBindings
    val byTargetRefMap      = mutable.Map[String, Seq[PolicyBinding]]()
    val byPolicyRefMap      = mutable.Map[String, Seq[PolicyBinding]]()
    val byDestinationRefMap = mutable.Map[String, Seq[PolicyBinding]]()

    bindings.foreach { b =>
      b.getTargetRefName.foreach(addToMap(_, b, byTargetRefMap))
      b.getPolicyRefName.foreach(addToMap(_, b, byPolicyRefMap))
      b.getDestinationRefName.foreach(addToMap(_, b, byDestinationRefMap))
    }
    PolicyBindingIndex(byTargetRefMap.toMap, byPolicyRefMap.toMap, byDestinationRefMap.toMap)
  }

  private def addToMap(name: String, b: PolicyBinding, map: mutable.Map[String, Seq[PolicyBinding]]): Unit = {
    map.get(name).fold(map.put(name, Seq(b))) { list =>
      map.put(name, list :+ b)
    }
  }
}

case class PolicyBindingIndex(
    private val byTargetRef: Map[String, Seq[PolicyBinding]],
    private val byPolicyRef: Map[String, Seq[PolicyBinding]],
    private val byDestinationRef: Map[String, Seq[PolicyBinding]]
) {
  def getBindingsFor(instance: APIInstance) = byTargetRef.get(instance.name).toSeq.flatten

  def getBindingsFor(service: Service) = byDestinationRef.get(service.name).toSeq.flatten

}
