package org.mulesoft.apb.project.client.platform

import amf.aml.client.scala.model.document.Dialect
import amf.apicontract.internal.convert.ApiClientConverters.ClientList
import amf.core.client.platform.resource.ResourceLoader
import amf.core.internal.convert.CoreClientConverters.ClientMap
import org.mulesoft.apb.project.client.platform.dependency.{
  DesignDependency,
  ExtensionDependency,
  ParsedDependency,
  ProfileDependency
}
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor

trait DependencySet {

  def design(): ClientList[DesignDependency]

  def validation(): ClientList[ProfileDependency]

  def designExtension(): ClientList[ExtensionDependency]

  def validationDialect(): Dialect

  def descriptor(): ProjectDescriptor

  def dependencyLoaders(): ClientMap[ResourceLoader]

  def allDependencies(): ClientList[ParsedDependency]
}
