package org.mulesoft.apb.project.client.platform.model

import amf.core.client.platform.model.document.BaseUnit
import amf.core.client.platform.validation.AMFValidationReport
import amf.shapes.client.platform.model.document.JsonLDInstanceDocument
import org.mulesoft.apb.project.client.platform.model.project.Project
import org.mulesoft.apb.project.client.scala.model.{
  BaseUnitBuildResult => InternalBaseUnitBuildResult,
  JsonLDInstanceDocumentBuildResult => InternalJsonLDInstanceDocumentBuildResult,
  ProjectBuildResult => InternalProjectBuildResult
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
@JSExportTopLevel("BaseUnitBuildResult")
case class BaseUnitBuildResult(private[apb] val _internal: InternalBaseUnitBuildResult) {
  def result(): BaseUnit            = BaseUnitMatcher.asClient(_internal.result)
  def report(): AMFValidationReport = ValidationReportMatcher.asClient(_internal.report)

  def conforms(): Boolean = _internal.conforms()

}

@JSExportAll
@JSExportTopLevel("ProjectBuildResult")
case class ProjectBuildResult(private[apb] val _internal: InternalProjectBuildResult) {
  def result(): Project             = ProjectConverter.asClient(_internal.result)
  def report(): AMFValidationReport = ValidationReportMatcher.asClient(_internal.report)

  def conforms(): Boolean = _internal.conforms()

}

@JSExportAll
@JSExportTopLevel("JsonLDInstanceDocumentBuildResult")
case class JsonLDInstanceDocumentBuildResult(private[apb] val _internal: InternalJsonLDInstanceDocumentBuildResult) {
  def result(): JsonLDInstanceDocument = JsonLDInstanceDocumentMatcher.asClient(_internal.result)
  def report(): AMFValidationReport    = ValidationReportMatcher.asClient(_internal.report)

  def conforms(): Boolean = _internal.conforms()

}
