package org.mulesoft.apb.project.client.scala

import amf.aml.client.scala.model.document.Dialect
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.dependency.ParsedDependency
import org.mulesoft.apb.project.client.scala.dependency.{DesignDependency, ExtensionDependency, ProfileDependency}
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor

trait DependencySet {

  def design(): Seq[DesignDependency]
  def validation(): Seq[ProfileDependency]
  def designExtension(): Seq[ExtensionDependency]
  def validationDialect(): Dialect
  def errors(): ProjectErrors
  def descriptor(): ProjectDescriptor
  def dependencyLoaders(): Map[String, ResourceLoader]
  def allDependencies(): Seq[ParsedDependency]
}
