package org.mulesoft.apb.project.internal.extensions.environment

import amf.core.client.scala.model.domain.AmfObject
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.{Field, ModelDefaultBuilder}
import org.mulesoft.apb.project.client.scala.extensions.environment.InstanceEnvironment
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Core, Management}

object InstanceEnvironmentModel extends ModelDefaultBuilder {

  val Id = Field(
      Str,
      Anypoint + "environmentID"
  )

  val Name = Field(
      Str,
      Core + "name"
  )

  val Type = Field(
      Str,
      Anypoint + "environmentType"
  )

  override def modelInstance: AmfObject = InstanceEnvironment()

  override def fields: List[Field] = List(Id, Name, Type)

  override val `type`: scala.List[ValueType] = List(ValueType(Management, "Environment"))
}
