package org.mulesoft.apb.project.client.platform

import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.project.client.platform.environment.DependencyFetcher
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import org.mulesoft.apb.project.internal.dependency.{DependencySetParser => InternalProjectBuilder}

import scala.concurrent.ExecutionContext
import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class DependencySetParser private[apb] (private[apb] val _internal: InternalProjectBuilder) {

  @JSExportTopLevel("DependencySetParser")
  def this(dependencyFetcher: DependencyFetcher, loaders: ClientList[ResourceLoader]) =
    this(InternalProjectBuilder(dependencyFetcher, loaders.asInternal.toList))

  def build(project: ProjectDescriptor): ClientFuture[DependencySet] =
    InternalFutureOps(_internal.build(project))(DependencySetConverter.asClient, ExecutionContext.global).asClient
}
