package org.mulesoft.apb.project.client.platform.descriptor

import amf.core.client.platform.validation.AMFValidationReport
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.descriptor.{
  DescriptorHandler => InternalExchangeDescriptorHandler,
  DescriptorParseResult => InternalDescriptorParseResult
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class DescriptorParseResult private[apb] (private[apb] val _internal: InternalDescriptorParseResult) {
  def descriptor: ProjectDescriptor = _internal.descriptor
  def report: AMFValidationReport   = _internal.report
}

@JSExportAll
@JSExportTopLevel("DescriptorHandler")
class DescriptorHandler {

  def parse(content: String): DescriptorParseResult =
    InternalExchangeDescriptorHandler().parse(content)

  def render(descriptor: ProjectDescriptor): String =
    InternalExchangeDescriptorHandler().render(descriptor._internal)

}
