package org.mulesoft.apb.project.client.scala.model.project

import amf.core.client.scala.model.document.{BaseUnit, EncodesModel}
import amf.core.client.scala.validation.AMFValidationResult
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.document.BaseUnitModel
import amf.core.internal.metamodel.document.DocumentModel.Encodes
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.{ProjectConfiguration, ProjectErrors}
import org.mulesoft.apb.project.client.scala.extensions.APIProjectExtension
import org.mulesoft.apb.project.client.scala.model.ProjectBuildResult
import org.mulesoft.apb.project.internal.model.ProjectDescriptorModel.Documentation
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.model.project.management.APIInstance
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Management
import org.mulesoft.apb.project.internal.idadoption.APBIdAdopter
import org.mulesoft.apb.project.internal.metamodel.ProjectDocumentModel
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.{Documentation => DocumentationNode}
import org.mulesoft.apb.project.internal.metamodel.ProjectInfoModel.{Contract, Instances}
import org.mulesoft.apb.project.internal.model.project.ProjectDocument
import org.mulesoft.apb.project.internal.view.ProjectView

case class Project(private[apb] val document: ProjectDocument) {

  private[apb] def projectInfo: ProjectInfo   = document.encodes
  def apiContract(): BaseUnit                 = projectInfo.apiContract()
  def instances(): Seq[APIInstance]           = projectInfo.instances().map(obj => APIInstance(obj))
  def documentation(): Seq[DocumentationNode] = projectInfo.documentation().map(obj => DocumentationNode(obj))
}
