package org.mulesoft.apb.project.client.scala.gcl

import amf.core.client.scala.model.domain.DomainElement
import amf.shapes.client.scala.model.domain.SemanticContext
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.gcl.GraphOps._

case class PolicyBinding(inner: JsonLDObject) {

  private val SPEC_IRI            = SemanticContext.baseIri + "spec"
  private val TARGET_REF_IRI      = SemanticContext.baseIri + "spec/targetRef"
  private val TARGER_REF_KIND_IRI = SemanticContext.baseIri + "spec/targetRef/kind"
  private val TARGER_REF_NAME_IRI = SemanticContext.baseIri + "spec/targetRef/name"

  def targetRefKind: Option[String]    = targetRef.flatMap(string(TARGER_REF_KIND_IRI))
  def targetRefName: Option[String]    = targetRef.flatMap(string(TARGER_REF_NAME_IRI))
  def targetRef: Option[DomainElement] = spec.flatMap(obj(TARGET_REF_IRI))
  def spec: Option[DomainElement]      = obj(SPEC_IRI)(inner)
}
