package org.mulesoft.apb.project.client.scala.instances

import amf.core.client.scala.model.domain.AmfArray
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.document.metamodel.JsonLDInstanceDocumentModel.Encodes
import org.mulesoft.apb.project.client.scala.gcl.{ApiInstance, PolicyBinding}
import org.mulesoft.apb.project.client.scala.instances.APIInstanceModel._
import org.mulesoft.apb.project.internal.instances.{ErrorAPIInstance, ResourceCatalog}

import scala.language.implicitConversions

class APIInstanceBuilder(instances: List[JsonLDInstanceDocument]) {

  private val catalog = ResourceCatalog(instances)

  def build(): JsonLDInstanceDocument = {
    val groupedBindings = catalog.getPolicyBindings.groupBy(binding => binding.targetRefName.get)
    val instances       = catalog.getApiInstances.map(inlineResources(groupedBindings))
    if (instances.isEmpty) wrap(List(ErrorAPIInstance))
    else wrap(instances)
  }

  private def inlineResources(byTargetRefName: Map[String, List[PolicyBinding]])(apiInstance: ApiInstance) = {
    val bindings        = findBindingsForInstance(apiInstance, byTargetRefName)
    val inlinedInstance = addPoliciesToInstance(bindings, apiInstance)
    inlinedInstance
  }

  private def findBindingsForInstance(apiInstance: ApiInstance, byTargetRefName: Map[String, List[PolicyBinding]]) = {
    apiInstance.name.flatMap(byTargetRefName.get).toList.flatten
  }

  private def wrap(nodes: Seq[JsonLDObject]) = JsonLDInstanceDocument().setWithoutId(Encodes, AmfArray(nodes))

  private def addPoliciesToInstance(bindings: List[PolicyBinding], apiInstance: ApiInstance): JsonLDObject = {
    val policies = findPolicyBindingSpec(bindings).toList
    apiInstance.addPolicies(policies)
  }
  private def findPolicyBindingSpec(bindings: Seq[PolicyBinding]) = bindings.flatMap(findBindingSpec)

  private def findBindingSpec(binding: PolicyBinding) = {
    binding.spec.map { spec =>
      spec.graph.removeField(TARGET_REF_FIELD_TERM.iri())
      spec.asInstanceOf[JsonLDObject]
    }
  }
}
