package org.mulesoft.apb.project.client.scala.instances

import amf.core.client.scala.vocabulary.{Namespace, ValueType}
import amf.core.internal.metamodel.{Field, Type}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.shapes.client.scala.model.domain.SemanticContext
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDElementModel
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Core, Management}

object APIInstanceModel {

  val API_INSTANCE_TERM: ValueType   = Management + "APIInstance"
  val POLICY_BINDING_TERM: ValueType = Management + "PolicyBinding"
  val POLICIES_FIELD_TERM: ValueType = Management + "policies"
  private val DEFAULT_BASE_IRI       = Namespace(SemanticContext.baseIri)
  val SPEC_FIELD_TERM                = DEFAULT_BASE_IRI + "spec"
  val METADATA_FIELD_TERM            = DEFAULT_BASE_IRI + "metadata"
  val METADATA_NAME_FIELD_TERM       = DEFAULT_BASE_IRI + "metadata/name"
  val SPEC_CLASS_TERM                = DEFAULT_BASE_IRI + "Spec"
  val TARGET_REF_FIELD_TERM          = DEFAULT_BASE_IRI + "spec/targetRef"

  val PoliciesField = Field(
      Type.Array(JsonLDElementModel),
      Management + "policies",
      ModelDoc(
          displayName = "policies"
      )
  )
}
