package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.model.{BoolField, StrField}
import amf.core.client.scala.vocabulary.Namespace
import amf.core.internal.metamodel.Field
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel.ProjectId

import scala.language.implicitConversions

trait JsonLDObjectWrapper {
  type This <: JsonLDObjectWrapper

  private[apb] val wrapped: JsonLDObject
  protected def copy(newWrapped: JsonLDObject): This
  private val namespace: Namespace = Namespace("http://anypoint.apb/vocabularies/dynamic#")

  def withDynamicProperty(key: String, value: String): This = copy(wrapped.withProperty((namespace + key).iri(), value))

  def withDynamicProperty(key: String, value: Int): This = copy(wrapped.withProperty((namespace + key).iri(), value))

  def withDynamicProperty(key: String, value: Boolean): This = copy(
      wrapped.withProperty((namespace + key).iri(), value)
  )

  def withDynamicProperty(key: String, value: Float): This = copy(wrapped.withProperty((namespace + key).iri(), value))

  def withDynamicProperty(key: String, value: JsonLDObject): This = copy(
      wrapped.withProperty((namespace + key).iri(), value)
  )
}
